var serviceURLHR =localStorage['serviceURLHR'];


$(document).ready(function(){
	$('#createEmployees').validate({ // initialize the plugin
			rules: {
				name: "required",
				phone:"required",
				dt_join:"required",
				password: { 
                required: true
				}, 
				confirm_password: { 
						required: true, equalTo: "#password"
				}, 
				gender: {
					required: function(element) {
						return $("#gender2").val() == '';
					}
				},
				department: {
					required: function(element) {
						return $("#department").val() == '';
					}
				},
				/*imdatesupervisor: {
					required: function(element) {
						return $("#imdatesupervisor").val() == '';
					}
				}*/
				designation: {
					required: function(element) {
						return $("#designation").val() == '';
					}
				},
				device_empid: {
                    required: true,
                    remote: {
                        url: serviceURLHR+"manageEmployees.php?action=checkemployeeid",
                        type: "post"
						//data:'device_empid='+$("#device_empid").val()
                     }
                }
			},
			messages: {
				name: "Please specify Employee's name.",
				device_empid: { 
				remote:"Employee ID already exist."
				},
				phone: "Please enter Employee's Phone No.",
				confirm_password: { 
				equalTo:"Password do not match with confirm password."
				}
				
			}
		});
});

jQuery('#department').live('change',loadDesignation);

loadDesignation();

function loadDesignation(){
	var dept=$('#department').val(); 
	if(dept)
	{
		var dept=dept;
	}
	else
	{
		var dept=0;
		
	} 
	$.getJSON(serviceURLHR + 'designations.php?action=load&dept='+dept,function(data){
		designation = data.designation;
		$("#designation").empty(); 
		if(!dept)
		{
			$('#designation').append('<option value="">Select Designation</option>');
		}
		$.each(designation, function(index, designation) {
									 
							$('#designation').append('<option value="'+designation.desig_id+'">'+designation.desig_name+'</option>');
							
		});	
	});
}

loadDepartment();

function loadDepartment(){ 
	$.getJSON(serviceURLHR + 'department.php?action=load',function(data){
		department = data.department;
		
		$.each(department, function(index, department) {
									 
							$('#department').append('<option value="'+department.depart_id+'">'+department.depart_name	+'</option>');
							
		});	
	});
	
}


loadimediatesupervisor();

function loadimediatesupervisor(){
	$('#imdatesupervisor').empty();
	$.getJSON(serviceURLHR + 'immediatesupervisor.php?action=load',function(data){
		imdsupervisor = data.imdsupervisor;
		$('#imdatesupervisor').append('<option value="">Immediate Supervisor</option>');
		$.each(imdsupervisor, function(index, imdsupervisor) {
									 
							$('#imdatesupervisor').append('<option value="'+imdsupervisor.e_id+'">'+imdsupervisor.e_fname	+'</option>');
							
		});	
	});
}


loadBranch();

function loadBranch(){
	$('#branch').empty();
	$.getJSON(serviceURLHR + 'branch.php?action=load',function(data){
		branch = data.branch;
		
		$.each(branch, function(index, branch) {
									 
				$('#branch').append('<option value="'+branch.branch_id+'">'+branch.branch_name	+'</option>');
							
		});	
		var bid = $('#branch').val();
		loadDevice(bid);
	});
	
}
function getUrlVars() {
    var vars = [], hash;
    var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
    for(var i = 0; i < hashes.length; i++){
        hash = hashes[i].split('=');
        vars.push(hash[0]);
        vars[hash[0]] = hash[1];
    }
    return vars;
}
loadEmployee();
function loadEmployee()
{
	var id = getUrlVars()["sel_id"];
	if(id!=""){
		$.getJSON(serviceURLHR +'recruitment.php?action=get_detail&sel_id='+id,function(data){
			   sel_list = data.sel_list;
			   $.each(sel_list, function(index, sel_list){ 
					$('#name').val(sel_list.sel_name_cand);	
					$('#gender2').val(sel_list.sel_gender);	
					$('#email').val(sel_list.sel_email);
					$('#phone').val(sel_list.sel_phone);
					$('#department').val(sel_list.sel_dept);
					$('#designation').val(sel_list.sel_desg);
			   });
		});	   
	}
	$('#sel_id').val(id);
}
$('#createEmployee').live('click',function(){
	
	$('#createEmployees').valid();
	if($('#createEmployees').valid()){
		saveEmployee();	
	}

});

function saveEmployee(){
	var dataString = $('#createEmployees').serialize();
	$.post(serviceURLHR + 'manageEmployees.php?action=insert',dataString,function(eid){
																				  
		if(!eid.error){																		  
			window.location = "profile-view.php?employ_id="+eid.eid+"&m=1";  // for set an alert
		 }else{
			alert("Sorry user limit Reached");																		  
		}
	},"json");
}

$('.cancelCreatingPerson').live('click',function(){
	window.location ="employee-lists.php";												 
});


	
	

$('#branch').change(function(){
	var bid = $(this).val();
	loadDevice(bid);						 
	
});

function loadDevice(bid){
	
	$.getJSON(serviceURLHR + 'device.php?action=load&bid='+bid,function(data){
		device = data.device;
		$('#device').html('');
		$.each(device, function(index, device) {
									 
				$('#device').append('<option value="'+device.dev_id+'">'+device.device_name	+'</option>');
							
		});	
	});
}